<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1\Conference;

use Twilio\Options;
use Twilio\Values;

abstract class ConferenceParticipantOptions {
    /**
     * @param string $events The events
     * @param string $metrics The metrics
     * @return FetchConferenceParticipantOptions Options builder
     */
    public static function fetch(string $events = Values::NONE, string $metrics = Values::NONE): FetchConferenceParticipantOptions {
        return new FetchConferenceParticipantOptions($events, $metrics);
    }

    /**
     * @param string $participantSid The participant_sid
     * @param string $label The label
     * @param string $events The events
     * @return ReadConferenceParticipantOptions Options builder
     */
    public static function read(string $participantSid = Values::NONE, string $label = Values::NONE, string $events = Values::NONE): ReadConferenceParticipantOptions {
        return new ReadConferenceParticipantOptions($participantSid, $label, $events);
    }
}

class FetchConferenceParticipantOptions extends Options {
    /**
     * @param string $events The events
     * @param string $metrics The metrics
     */
    public function __construct(string $events = Values::NONE, string $metrics = Values::NONE) {
        $this->options['events'] = $events;
        $this->options['metrics'] = $metrics;
    }

    /**
     * The events
     *
     * @param string $events The events
     * @return $this Fluent Builder
     */
    public function setEvents(string $events): self {
        $this->options['events'] = $events;
        return $this;
    }

    /**
     * The metrics
     *
     * @param string $metrics The metrics
     * @return $this Fluent Builder
     */
    public function setMetrics(string $metrics): self {
        $this->options['metrics'] = $metrics;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.FetchConferenceParticipantOptions ' . $options . ']';
    }
}

class ReadConferenceParticipantOptions extends Options {
    /**
     * @param string $participantSid The participant_sid
     * @param string $label The label
     * @param string $events The events
     */
    public function __construct(string $participantSid = Values::NONE, string $label = Values::NONE, string $events = Values::NONE) {
        $this->options['participantSid'] = $participantSid;
        $this->options['label'] = $label;
        $this->options['events'] = $events;
    }

    /**
     * The participant_sid
     *
     * @param string $participantSid The participant_sid
     * @return $this Fluent Builder
     */
    public function setParticipantSid(string $participantSid): self {
        $this->options['participantSid'] = $participantSid;
        return $this;
    }

    /**
     * The label
     *
     * @param string $label The label
     * @return $this Fluent Builder
     */
    public function setLabel(string $label): self {
        $this->options['label'] = $label;
        return $this;
    }

    /**
     * The events
     *
     * @param string $events The events
     * @return $this Fluent Builder
     */
    public function setEvents(string $events): self {
        $this->options['events'] = $events;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.ReadConferenceParticipantOptions ' . $options . ']';
    }
}